#!/bin/bash
# export datasets1="Cora CiteSeer PubMed OGBN-Arxiv"
export datasets2="cs physics wikics"
export missing_rates="0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.99 0.999 0.9999 1.0"
export lambda_list_1="0.00001"
export lambda_list_2="0.00001 0.0001 0.001 0.01 0.1 1 10"
export lp_alpha_list="0.9 0.99 0.999 0.9999"
export embedders="GNN"
export embedder_lp_list="GCN_LPA Correct_Smooth"
export attn_type="random sum mean concat"
export gpu=2

# uniform - GNN
for dataset in $datasets2
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method zero --label_trick True --mask_rate 1.0 --n_reuse 1 --n_runs 10 --gpu ${gpu}
done
done

# row - GNN
for dataset in $datasets2
do
for missing_rate in $missing_rates
do
python main.py --dataset ${dataset} --missing_type row --missing_rate ${missing_rate} --embedder GNN --gnn GCN --filling_method zero --label_trick True --mask_rate 1.0 --n_reuse 1 --n_runs 10 --gpu ${gpu}
done
done

# # uniform - TWIRLS
# for dataset in $datasets2
# do
# for missing_rate in $missing_rates
# do
# python main.py --dataset ${dataset} --missing_type uniform --missing_rate ${missing_rate} --embedder TWIRLS --filling_method zero --n_runs 10 --gpu ${gpu}
# done
# done